<!DOCTYPE html>
<html lang="en" dir="ltr" data-bs-theme="light" data-color-theme="Aqua_Theme" data-layout="vertical">

<head>
  <meta charset="UTF-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <link rel="shortcut icon" type="image/png" href="./assets/images/logos/logo.png" />
  <link rel="stylesheet" href="./assets/libs/datatables.net-bs5/css/dataTables.bootstrap5.min.css" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
  <link rel="stylesheet" href="./assets/css/styles.css" />
  
  <title>Capilla Cristo Redentor</title>
</head>

<body>
  <!-- Toast -->
  <div class="toast toast-onload align-items-center text-bg-primary border-0" role="alert" aria-live="assertive" aria-atomic="true">
    <div class="toast-body hstack align-items-start gap-6">
      <i class="ti ti-alert-circle fs-6"></i>
      <div>
        <h5 class="text-white fs-3 mb-1">Bienvendido</h5>
        <h6 class="text-white fs-2 mb-0">Dios te bendiga.</h6>
      </div>
      <button type="button" class="btn-close btn-close-white fs-2 m-0 ms-auto shadow-none" data-bs-dismiss="toast" aria-label="Close"></button>
    </div>
  </div>
  <!-- Preloader -->
  <div class="preloader">
    <img src="./assets/images/logos/logo.png" alt="loader" class="lds-ripple img-fluid" />
  </div>
  <div id="main-wrapper">
    <!-- Sidebar Start -->
    <aside class="side-mini-panel with-vertical">
      <!-- ---------------------------------- -->
      <!-- Start Vertical Layout Sidebar -->
      <!-- ---------------------------------- -->
      <div class="iconbar">
        <div>
          <div class="mini-nav">
            <div class="brand-logo d-flex align-items-center justify-content-center">
              <a class="nav-link sidebartoggler" id="headerCollapse" href="javascript:void(0)">
                <iconify-icon icon="solar:hamburger-menu-line-duotone" class="fs-7"></iconify-icon>
              </a>
            </div>
            <ul class="mini-nav-ul" data-simplebar>
              <li class="mini-nav-item" id="mini-1">
                <a href="javascript:void(0)" data-bs-toggle="tooltip" data-bs-custom-class="custom-tooltip" data-bs-placement="right" data-bs-title="Dashboard">
                  <iconify-icon icon="solar:pulse-2-line-duotone" class="fs-7"></iconify-icon>
                </a>
              </li>
              <li class="mini-nav-item" id="mini-2">
                <a href="javascript:void(0)" data-bs-toggle="tooltip" data-bs-custom-class="custom-tooltip" data-bs-placement="right" data-bs-title="Mantenimientos">
                  <iconify-icon icon="solar:pen-new-square-line-duotone" class="fs-7"></iconify-icon>
                </a>
              </li>
              <li>
                <span class="sidebar-divider lg"></span>
              </li>
              <li class="mini-nav-item" id="mini-3">
                <a href="javascript:void(0)" data-bs-toggle="tooltip" data-bs-custom-class="custom-tooltip" data-bs-placement="right" data-bs-title="Servicios">
                  <iconify-icon icon="solar:money-bag-line-duotone" class="fs-7"></iconify-icon>
                </a>
              </li>
              <li class="mini-nav-item" id="mini-4">
                <a href="javascript:void(0)" data-bs-toggle="tooltip" data-bs-custom-class="custom-tooltip" data-bs-placement="right" data-bs-title="Calendario">
                  <iconify-icon icon="solar:calendar-line-duotone" class="fs-7"></iconify-icon>
                </a>
              </li>
              <li class="mini-nav-item" id="mini-5">
                <a href="javascript:void(0)" data-bs-toggle="tooltip" data-bs-custom-class="custom-tooltip" data-bs-placement="right" data-bs-title="Gastos">
                  <iconify-icon icon="solar:cart-large-2-line-duotone" class="fs-7"></iconify-icon>
                </a>
              </li>
              <li class="mini-nav-item" id="mini-6">
                <a href="javascript:void(0)" data-bs-toggle="tooltip" data-bs-custom-class="custom-tooltip" data-bs-placement="right" data-bs-title="Inventario">
                  <iconify-icon icon="solar:archive-line-duotone" class="fs-7"></iconify-icon>
                </a>
              </li>
              <li>
                <span class="sidebar-divider lg"></span>
              </li>
              <li class="mini-nav-item" id="mini-7">
                <a href="javascript:void(0)" data-bs-toggle="tooltip" data-bs-custom-class="custom-tooltip" data-bs-placement="right" data-bs-title="Reportes">
                  <iconify-icon icon="solar:pie-chart-2-line-duotone" class="fs-7"></iconify-icon>
                </a>
              </li>
              <li class="mini-nav-item" id="mini-8">
                <a href="javascript:void(0)" data-bs-toggle="tooltip" data-bs-custom-class="custom-tooltip" data-bs-placement="right" data-bs-title="Administración">
                  <iconify-icon icon="solar:settings-line-duotone" class="fs-7"></iconify-icon>
                </a>
              </li>
            </ul>
          </div>
          <div class="sidebarmenu">
            <div class="brand-logo d-flex align-items-center nav-logo">
              <a href="./" class="text-nowrap logo-img">
                <img src="./assets/images/logos/dark-logo.svg" alt="Logo" width="180px">
              </a>
            </div>
            <nav class="sidebar-nav" id="menu-right-mini-1" data-simplebar>
              <ul class="sidebar-menu" id="sidebarnav">
                <li class="nav-small-cap">
                  <span class="hide-menu">Dashboard</span>
                </li>
                <li class="sidebar-item">
                  <a class="sidebar-link" href="dashboard" id="get-url" aria-expanded="false">
                    <iconify-icon icon="solar:spedometer-max-line-duotone"></iconify-icon>
                    <span class="hide-menu">Dashboard principal</span>
                  </a>
                </li>
              </ul>
            </nav>
            <nav class="sidebar-nav scroll-sidebar" id="menu-right-mini-2" data-simplebar>
              <ul class="sidebar-menu" id="sidebarnav">
                <li class="nav-small-cap">
                  <span class="hide-menu">MANTENIMIENTOS</span>
                </li>
                <li class="sidebar-item">
                  <a href="productos" class="sidebar-link">
                    <iconify-icon icon="solar:notes-line-duotone"></iconify-icon>
                    <span class="hide-menu">Productos</span>
                  </a>
                </li>
                <li class="sidebar-item">
                  <a href="misas" class="sidebar-link">
                    <iconify-icon icon="solar:wineglass-line-duotone"></iconify-icon>
                    <span class="hide-menu">Misas</span>
                  </a>
                </li>
                <li class="sidebar-item">
                  <a href="sacramentos" class="sidebar-link">
                    <iconify-icon icon="solar:star-shine-line-duotone"></iconify-icon>
                    <span class="hide-menu">Sacramentos</span>
                  </a>
                </li>
              </ul>
            </nav>
            <nav class="sidebar-nav scroll-sidebar" id="menu-right-mini-3" data-simplebar>
              <ul class="sidebar-menu" id="sidebarnav">
                <li class="nav-small-cap">
                  <span class="hide-menu">SERVICIOS</span>
                </li>
                <li class="sidebar-item">
                  <a href="venta_producto" class="sidebar-link">
                    <iconify-icon icon="solar:notes-line-duotone"></iconify-icon>
                    <span class="hide-menu">Tienda</span>
                  </a>
                </li>
                <li class="sidebar-item">
                  <a href="venta_misa" class="sidebar-link">
                    <iconify-icon icon="solar:wineglass-line-duotone"></iconify-icon>
                    <span class="hide-menu">Misas</span>
                  </a>
                </li>
                <li class="sidebar-item">
                  <a href="venta_sacramento" class="sidebar-link">
                    <iconify-icon icon="solar:star-shine-line-duotone"></iconify-icon>
                    <span class="hide-menu">Sacramentos</span>
                  </a>
                </li>
                <li class="sidebar-item">
                  <a href="venta_constancia" class="sidebar-link">
                    <iconify-icon icon="solar:file-text-line-duotone"></iconify-icon>
                    <span class="hide-menu">Constancias</span>
                  </a>
                </li>
              </ul>
            </nav>
            <nav class="sidebar-nav scroll-sidebar" id="menu-right-mini-4" data-simplebar>
              <ul class="sidebar-menu" id="sidebarnav">
                <li class="nav-small-cap">
                  <span class="hide-menu">CALENDARIO</span>
                </li>
                <li class="sidebar-item">
                  <a href="calendario" class="sidebar-link">
                    <iconify-icon icon="solar:calendar-search-line-duotone"></iconify-icon>
                    <span class="hide-menu">Mensual</span>
                  </a>
                </li>
                <li class="sidebar-item">
                  <a href="crea_evento" class="sidebar-link">
                    <iconify-icon icon="solar:calendar-add-line-duotone"></iconify-icon>
                    <span class="hide-menu">Agregar evento</span>
                  </a>
                </li>
              </ul>
            </nav>
            <nav class="sidebar-nav scroll-sidebar" id="menu-right-mini-5" data-simplebar>
              <ul class="sidebar-menu" id="sidebarnav">
                <li class="nav-small-cap">
                  <span class="hide-menu">GASTOS</span>
                </li>
                <li class="sidebar-item">
                  <a href="gastos" class="sidebar-link">
                    <iconify-icon icon="solar:cart-large-4-line-duotone"></iconify-icon>
                    <span class="hide-menu">Últimos Gastos</span>
                  </a>
                </li>
                <li class="sidebar-item">
                  <a href="crea_gasto" class="sidebar-link">
                    <iconify-icon icon="solar:cart-plus-line-duotone"></iconify-icon>
                    <span class="hide-menu">Agregar</span>
                  </a>
                </li>
              </ul>
            </nav>
            <nav class="sidebar-nav scroll-sidebar" id="menu-right-mini-6" data-simplebar>
              <ul class="sidebar-menu" id="sidebarnav">
                <li class="nav-small-cap">
                  <span class="hide-menu">INVENTARIO</span>
                </li>
                <li class="sidebar-item">
                  <a href="inventario" class="sidebar-link">
                    <iconify-icon icon="solar:checklist-minimalistic-line-duotone"></iconify-icon>
                    <span class="hide-menu">Inventario</span>
                  </a>
                </li>
                <li class="sidebar-item">
                  <a href="crea_stock" class="sidebar-link">
                    <iconify-icon icon="solar:clipboard-add-line-duotone"></iconify-icon>
                    <span class="hide-menu">Agregar producto</span>
                  </a>
                </li>
              </ul>
            </nav>
            <nav class="sidebar-nav scroll-sidebar" id="menu-right-mini-7" data-simplebar>
              <ul class="sidebar-menu" id="sidebarnav">
                <li class="nav-small-cap">
                  <span class="hide-menu">REPORTES</span>
                </li>
                <li class="sidebar-item">
                  <a href="rep_inventario" class="sidebar-link">
                    <iconify-icon icon="solar:cart-check-line-duotone"></iconify-icon>
                    <span class="hide-menu">Inventario</span>
                  </a>
                </li>
                <li class="sidebar-item">
                  <a href="rep_ingresos" class="sidebar-link">
                    <iconify-icon icon="solar:maximize-square-3-line-duotone"></iconify-icon>
                    <span class="hide-menu">Ingresos</span>
                  </a>
                </li>
                <li class="sidebar-item">
                  <a href="rep_egresos" class="sidebar-link">
                    <iconify-icon icon="solar:minimize-square-3-line-duotone"></iconify-icon>
                    <span class="hide-menu">Gastos</span>
                  </a>
                </li>
                <li class="sidebar-item">
                  <a href="rep_aportes" class="sidebar-link">
                    <iconify-icon icon="solar:home-add-line-duotone"></iconify-icon>
                    <span class="hide-menu">Aporte Diócesis</span>
                  </a>
                </li>
              </ul>
            </nav>
            <nav class="sidebar-nav scroll-sidebar" id="menu-right-mini-8" data-simplebar>
              <ul class="sidebar-menu" id="sidebarnav">
                <li class="nav-small-cap">
                  <span class="hide-menu">ADMINISTRACIÓN</span>
                </li>
                <li class="sidebar-item">
                  <a href="adm_ticket" class="sidebar-link">
                    <iconify-icon icon="solar:bill-check-line-duotone"></iconify-icon>
                    <span class="hide-menu">Ticket de venta</span>
                  </a>
                </li>
                <li class="sidebar-item">
                  <a href="adm_usuarios" class="sidebar-link">
                    <iconify-icon icon="solar:users-group-rounded-line-duotone"></iconify-icon>
                    <span class="hide-menu">Usuarios</span>
                  </a>
                </li>
                <li class="sidebar-item">
                  <a href="adm_roles" class="sidebar-link">
                    <iconify-icon icon="solar:user-block-line-duotone"></iconify-icon>
                    <span class="hide-menu">Roles</span>
                  </a>
                </li>
                <li class="sidebar-item">
                  <a href="adm_cajas" class="sidebar-link">
                    <iconify-icon icon="solar:cart-5-line-duotone"></iconify-icon>
                    <span class="hide-menu">Cajas</span>
                  </a>
                </li>
              </ul>
            </nav>
          </div>
        </div>
      </div>
    </aside>
    <div class="page-wrapper">
      <header class="topbar">
        <div class="with-vertical">
          <nav class="navbar navbar-expand-lg p-0">
            <ul class="navbar-nav">
              <li class="nav-item d-flex d-xl-none">
                <a class="nav-link nav-icon-hover-bg rounded-circle  sidebartoggler " id="headerCollapse" href="javascript:void(0)">
                  <iconify-icon icon="solar:hamburger-menu-line-duotone" class="fs-6"></iconify-icon>
                </a>
              </li>
              <li class="nav-item d-none d-xl-flex nav-icon-hover-bg rounded-circle">
                <a class="nav-link" href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#exampleModal">
                  <iconify-icon icon="solar:magnifer-linear" class="fs-6"></iconify-icon>
                </a>
              </li>
            </ul>
            <div class="d-block d-lg-none py-9 py-xl-0">
              <img src="./assets/images/logos/dark-logo.svg" alt="matdash-img" width="180px" />
            </div>
            <a class="navbar-toggler p-0 border-0 nav-icon-hover-bg rounded-circle" href="javascript:void(0)" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
              <iconify-icon icon="solar:menu-dots-bold-duotone" class="fs-6"></iconify-icon>
            </a>
            <div class="collapse navbar-collapse justify-content-end" id="navbarNav">
              <div class="d-flex align-items-center justify-content-between">
                <ul class="navbar-nav flex-row mx-auto ms-lg-auto align-items-center justify-content-center">

                  <li class="nav-item">
                    <a class="nav-link moon dark-layout nav-icon-hover-bg rounded-circle" href="javascript:void(0)">
                      <iconify-icon icon="solar:moon-line-duotone" class="moon fs-6"></iconify-icon>
                    </a>
                    <a class="nav-link sun light-layout nav-icon-hover-bg rounded-circle" href="javascript:void(0)" style="display: none">
                      <iconify-icon icon="solar:sun-2-line-duotone" class="sun fs-6"></iconify-icon>
                    </a>
                  </li>
                  <li class="nav-item d-block d-xl-none">
                    <a class="nav-link nav-icon-hover-bg rounded-circle" href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#exampleModal">
                      <iconify-icon icon="solar:magnifer-line-duotone" class="fs-6"></iconify-icon>
                    </a>
                  </li>
                  <li class="nav-item dropdown nav-icon-hover-bg rounded-circle">
                    <a class="nav-link position-relative" href="javascript:void(0)" id="drop2" aria-expanded="false">
                      <iconify-icon icon="solar:bell-bing-line-duotone" class="fs-6"></iconify-icon>
                    </a>
                    <div class="dropdown-menu content-dd dropdown-menu-end dropdown-menu-animate-up" aria-labelledby="drop2">
                      <div class="d-flex align-items-center justify-content-between py-3 px-7">
                        <h5 class="mb-0 fs-5 fw-semibold">Notificaciones</h5>
                        <span class="badge text-bg-primary rounded-4 px-3 py-1 lh-sm">2 nuevas</span>
                      </div>
                      <div class="message-body" data-simplebar>
                        <a href="javascript:void(0)" class="py-6 px-7 d-flex align-items-center dropdown-item gap-3">
                          <span class="flex-shrink-0 bg-danger-subtle rounded-circle round d-flex align-items-center justify-content-center fs-6 text-danger">
                            <iconify-icon icon="solar:widget-3-line-duotone"></iconify-icon>
                          </span>
                          <div class="w-75">
                            <div class="d-flex align-items-center justify-content-between">
                              <h6 class="mb-1 fw-semibold">Reunión consejo chico</h6>
                              <span class="d-block fs-2">9:30 AM</span>
                            </div>
                            <span class="d-block text-truncate text-truncate fs-11">Revisar evento navideño</span>
                          </div>
                        </a>
                        <a href="javascript:void(0)" class="py-6 px-7 d-flex align-items-center dropdown-item gap-3">
                          <span class="flex-shrink-0 bg-primary-subtle rounded-circle round d-flex align-items-center justify-content-center fs-6 text-primary">
                            <iconify-icon icon="solar:calendar-line-duotone"></iconify-icon>
                          </span>
                          <div class="w-75">
                            <div class="d-flex align-items-center justify-content-between">
                              <h6 class="mb-1 fw-semibold">Reunión catequesis</h6>
                              <span class="d-block fs-2">11:15 AM</span>
                            </div>
                            <span class="d-block text-truncate text-truncate fs-11">Con la catequesis de adultos</span>
                          </div>
                        </a>
                      </div>
                      <div class="py-6 px-7 mb-1">
                        <button class="btn btn-primary w-100">Ver todas las notificaciones</button>
                      </div>
                    </div>
                  </li>
                  <li class="nav-item dropdown">
                    <a class="nav-link" href="javascript:void(0)" id="drop1" aria-expanded="false">
                      <div class="d-flex align-items-center gap-2 lh-base">
                        <img src="./assets/images/profile/user-1.jpg" class="rounded-circle" width="35" height="35" alt="matdash-img" />
                        <iconify-icon icon="solar:alt-arrow-down-bold" class="fs-2"></iconify-icon>
                      </div>
                    </a>
                    <div class="dropdown-menu profile-dropdown dropdown-menu-end dropdown-menu-animate-up" aria-labelledby="drop1">
                      <div class="position-relative px-4 pt-3 pb-2">
                        <div class="d-flex align-items-center mb-3 pb-3 border-bottom gap-6">
                          <img src="./assets/images/profile/user-1.jpg" class="rounded-circle" width="56" height="56" alt="matdash-img" />
                          <div>
                            <h5 class="mb-0 fs-12">Admin
                              <span class="text-success fs-11"> Pro</span>
                            </h5>
                            <p class="mb-0 text-dark">
                              admin@xtoredentor.pe
                            </p>
                          </div>
                        </div>
                        <div class="message-body">
                          <a href="javascript:void(0)" class="p-2 dropdown-item h6 rounded-1">
                            Mi Perfil
                          </a>
                          <a href="javascript:void(0)" class="p-2 dropdown-item h6 rounded-1">
                            Configuraciones
                          </a>
                          <a href="./main/authentication-login2.html" class="p-2 dropdown-item h6 rounded-1">
                            Cerrar sesión
                          </a>
                        </div>
                      </div>
                    </div>
                  </li>
                </ul>
              </div>
            </div>
          </nav>
        </div>
      </header>
      <!--  Header End -->